// 
/// \file hwapihatteland.h 
// 
// $Id$ 
// 
// Library: <LibraryName> 
// Package: <PackageName> 
// Module:  <ModuleName> 
// 
/// Header file of exported function to access SMBus and IO
//  The functions are used for accessing SMBus and IO directly
//  or to acccess the functionality by sending the Command name
// 
// Copyright (c) 2011, REC Research and Engineering Center d.d.
// All rights reserved. 
//  
// <License Notice> 
//

#ifndef __HWAPIHATTLAND_H_
#define __HWAPIHATTLAND_H_

#if defined(WIN32) || defined(_WIN32)
#include <windows.h>
#else
#define _stdcall
#include "hwapi_linuxtypes.h"
#include "hwapi_portable.h"
#endif

#include "hwapi_errcodes.h"
#include "hwapi_cmds.h"

#ifdef  __cplusplus 
extern "C" {
#endif

#define PACKET_MAX_SIZE_BYTES	72
#define PACKET_MAX_PACKAGES		57

/**
Function which is responsible for reading a byte from the SMBus controller
\param [in] DeviceID Address of the device on the SMBus
\param [in] RegIndex Address of the data to be read.
\param [in] Byte	 Byte Data which is read from the device
\return ERROR_NONE if the operation was successful, otherwise one of the defined errror codes.
*/
UINT8 SMBusByteRead(UINT16 DeviceID, UINT8 RegIndex, UINT8 *Byte);

/**
Function which is responsible for writing a byte to the SMBus controller
\param [in] DeviceID Address of the device on the SMBus
\param [in] RegIndex Address of the data to be read.
\param [in] Byte	 Byte Data which is written to the device
\return ERROR_NONE if the operation was successful, otherwise one of the defined errror codes.
*/
UINT8 SMBusByteWrite(UINT16 DeviceID, UINT8 RegIndex, UINT8 Byte);

/**
Function which is responsible for reading a word from the SMBus controller
\param [in] DeviceID Address of the device on the SMBus
\param [in] RegIndex Address of the data to be read.
\param [in] Bytes	 Byte Data which is read to the device
\return ERROR_NONE if the operation was successful, otherwise one of the defined errror codes.
*/
UINT8 SMBusWordRead(UINT16 DeviceID, UINT8 RegIndex, UINT8 *Bytes);

/**
Function which is responsible for writing a word to the SMBus controller
\param [in] DeviceID Address of the device on the SMBus
\param [in] RegIndex Address of the data to be read.
\param [in] Word	 Word Data which is written to the device
\return ERROR_NONE if the operation was successful, otherwise one of the defined errror codes.
*/
UINT8 SMBusWordWrite(UINT16 DeviceID, UINT8 RegIndex, UINT16 Word);

/**
Function which is responsible for reading a block of data from the SMBus controller
\param [in] DeviceID Address of the device on the SMBus
\param [in] RegIndex Address of the data to be read.
\param [in] Bytes	 Byte Data which is read from the device
\param [in] nBytes	 Number of bytes stored in Bytes
\return ERROR_NONE if the operation was successful, otherwise one of the defined errror codes.
*/
UINT8 SMBusBlockRead(UINT16 DeviceID, UINT8 RegIndex, UINT8 *Bytes, UINT8 *nBytes);

/**
Function which is responsible for writing a block to the SMBus controller. Max 32 bytes can be written at once
NOTE: NOT SUPPORTED ON LINUX PLATFORM
\param [in] DeviceID Address of the device on the SMBus
\param [in] RegIndex Address of the data to be read.
\param [in] Bytes	 Byte Data which is written to the device
\param [in] nBytes	 Number of bytes stored in Bytes
\return ERROR_NONE if the operation was successful, otherwise one of the defined errror codes.
*/
#if defined(WIN32) || defined(_WIN32)
UINT8 SMBusBlockWrite(UINT16 DeviceID, UINT8 RegIndex, UINT8 *Bytes, UINT8 nBytes);
#endif

/**
Function which is responsible for writing commands to devices
\param [in] CmdName		One of the commands specified in "hwapi_cmds.h"
\param [in] RW			0 if command should be written, 1 if a read should be performed
\param [in] InputData	InputData (used for reads). Number of bytes which have been read are stored in nbytes
\param [in] OutputData	OutputData (used for writes if applicable). Number of bytes in nbytes should be defined
\param [in] nbytes	    Number of bytes in which should be written or number of bytes read depending on RW
\return ERROR_NONE if the operation was successful, otherwise one of the defined errror codes.
*/
UINT8 HWAPIcommandRW(UINT32 CmdName, BOOL RW, UINT8 *InputData, UINT8 *OutputData, UINT8 *nbytes);

/**
Function for getting the detected HW platform type.
\return one of the constants defined in hw platform constants define in "hwapi_cmds.h" 
(HW_PLATFORM_AIPC, HW_PLATFORM_QM57, HW_PLATFORM_IPC), 255 0xFF if the plaform was not detected.
*/
UINT8 HWAPIGetType();

/**
Function for checking if the kernel driver loaded properly
\return TRUE if procedure passed without problems, FALSE otherwise 
*/
BOOL HWGetDriverStatus(); 

#ifdef  __cplusplus 
}
#endif
#endif //__HWAPIHATTLAND_H_




